/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于获取控制芯片列表/显示芯片列表/行管芯片列表
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.05.31
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_jungle_row_col_uint */
/* exported mc_construct_pin_mods_cnt */
/* exported mc_construct_pin_mods_data */
/* exported mc_set_all_mod_cnt_offset */
/* exported mc_handle_layout_module */
/* exported mc_handle_col_data */
/* exported mc_layout_get_data_idx_in_name */
/* exported mc_layout_get_box_basic */
/* exported mc_get_box_xml */


/* global mc_sdk_param */
/* global mc_sdk_recvcard */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断当前设置的宽高参数是否为设定的模组的宽高整数倍
 * 参数:
 *    @param {Promise<object>} obj 界面参数
 *    @param {Promise<string>} str_mod_width 已知的当前模组宽
 *    @param {Promise<string>} str_mod_height 已知的当前模组高
 * 返回：
 *   @returns {Promise<boolean>} b_result 设置的参数是否为正整数
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.05.31
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_jungle_row_col_uint(obj, str_mod_width, str_mod_height) {
    var b_result = false;
    var ui_row = Number(obj.height) / Number(str_mod_height);
    var ui_col = Number(obj.width) / Number(str_mod_width);

    if (-1 === (ui_row.toString()).indexOf(".") && -1 === (ui_col.toString()).indexOf(".")) {
        b_result = true;
        obj.row = ui_row;
        obj.col = ui_col;
    }
    return b_result;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    构造模组数据格式
 * 参数:
 *    NA
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.05.31
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_construct_pin_mods_cnt() {
    // eslint-disable-next-line no-unused-expressions
    this.jx_num = "";
    this.children = [];
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    构建JX对象数据格式
 * 参数:
 *    @param {Promise<string>} str_mod_name 模组参数
 *    @param {Promise<string>} str_offset_x x偏移
 *    @param {Promise<string>} str_offset_y y偏移
 * 返回：
 *    @return {Promise<object>} obj_return 对象参数
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.05.31
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_construct_pin_mods_data(str_mod_name, str_offset_x, str_offset_y) {
    var obj_return;

    obj_return = {
        mirror: "0",
        module_name: str_mod_name,
        rotation: "0,0,0",
        scale: "0.0,0.0,1.0,1.0",
        offset_x: str_offset_x,
        offset_y: str_offset_y,
        cut: "0,0,0,0"
    };

    return obj_return;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    构造模组数据格式
 * 参数:
 *   @param {Promise<Number>} obj j值顺序
 * 返回：
 *    @return {Promise<Array>} arr_result 对象参数
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.01
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_all_mod_cnt_offset(obj) {
    var arr_result = [];
    // 获取宽高模组名称 创建数量 搭建结构
    var ui_row = obj.row;
    var ui_col = obj.col;
    var str_mod_name = obj.mod_name;

    var ui_x_offset = 0;
    var ui_y_offset = 0;

    var mod_width = Number(obj.width) / ui_col;
    var mod_height = Number(obj.height) / ui_row;

    arr_result.length = ui_row;
    for (var idx_row = 0; idx_row < ui_row; idx_row++) {
        arr_result[idx_row] = [];
        // arr_result[idx_row].length = ui_col;
        for (var idx_col = 0; idx_col < ui_col; idx_col++) {
            arr_result[idx_row].push(mc_construct_pin_mods_data(str_mod_name, ui_x_offset, ui_y_offset));
            ui_x_offset += mod_width;
        }
        ui_x_offset = 0;
        ui_y_offset += mod_height;
    }
    return arr_result;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    快速连线 处理级联/对开/顺序
 * 参数:
 *     @param {Promise<Object>} obj_data 界面参数
 *     @param {Promise<Array>} arr_mod 设置模块jq数组
 *     @param {Promise<Number>} ui_hub_num 起始对开下标 如J1或P1 === 1
 * 返回：
 *     @returns {Promise<Object>}
 *      false 参数错误
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.01
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_layout_module(obj_data, arr_mod, ui_hub_num) {
    // if ("object" !== typeof obj_data) {
    //     return false;
    // }
    // if ("[object Array]" !== Object.prototype.toString.call(arr_mod) || 0 === arr_mod.length) {
    //     return false;
    // }

    var arr_result = [];

    var init_hub_name = ui_hub_num;
    // 取值；级联方向，输出方式，插头顺序；
    var mod_cascade_dir = obj_data.cascade;
    var mod_output_mode = obj_data.output;
    var mod_order = obj_data.plug;

    // 以级联设置方向 0/1 为横向长度 2/3为纵向长度 初始方向正面长度

    // 级联方式设置 ------
    // 设置为y轴级联方向
    if ("2" === mod_cascade_dir || "3" === mod_cascade_dir) {
        // 获取垂直排列数据
        arr_mod = mc_handle_y_direction_mod(arr_mod);
    }

    var ui_init_direction_length = arr_mod[0].length;

    // 输出方式设置 ------
    // 每组数据数
    var ui_mode_num = Number(mod_output_mode) + 1;
    // 求余
    var mode_rem = ui_init_direction_length % ui_mode_num;
    // 对开方式的一组个数(有对开情况下相同jx值为一组，mode_gp_num 示该组jx值有多少个模组)
    var mode_gp_num = Math.floor(ui_init_direction_length / ui_mode_num);
    // 定义对开排列数组 每组数据个数；
    var arr_output_sort = new Array(ui_mode_num);

    for (var idx = 0; idx < arr_output_sort.length; idx++) {
        arr_output_sort[idx] = mode_gp_num;
        if (0 !== mode_rem) {
            arr_output_sort[idx] = mode_gp_num + 1;
            mode_rem--;
        }
    }


    // 插头顺序设置 -------
    // if ("1" === mod_order) {
    // // 数据外层反向
    //     arr_mod = arr_mod.reverse();
    // }

    // if ("1" === mod_cascade_dir || "3" === mod_cascade_dir) {
    // // 内层反向
    //     for (var item = 0; item < arr_mod.length; item++) {
    //         arr_mod[item] = arr_mod[item].reverse();
    //     }
    // }
    // 构造连线数据 -------
    var str_hub_name = "J";

    var u_index = 0;

    // 每组赋值方向
    var arr_pot = mc_get_split_pot(arr_output_sort);

    // 列从左到右 [3,3,2]
    for (var i = 0; i < arr_output_sort.length; i++) {
        // 3
        var ui_num = arr_output_sort[i];
        var ui_index = ui_hub_num;

        if (i) {
            // ui_index = arr_mod.length * i + 1;
            ui_index = arr_mod.length * i + init_hub_name;
        }

        for (var j = 0; j < ui_num; j++) {
            var ui_push = arr_pot[u_index];

            // 相同line数据
            ui_hub_num = ui_index;
            for (var index = 0; index < arr_mod.length; index++) {
                // 每行数据
                var arr_item = arr_mod[index];
                var obj_target = arr_item[ui_push];

                if (!obj_target) {
                    continue;
                }

                var str_txt = str_hub_name + ui_hub_num;
                var str_key = str_txt.trim();

                obj_target.jx_num = str_key;

                ui_hub_num++;
            }
            u_index++;
        }
    }
    arr_result = arr_mod;
    return [arr_result, arr_output_sort];
}

/* * 功能:
* 处理纵向级联的存储数据 */
function mc_handle_y_direction_mod(arr) {
    var arr_result = [];
    var ui_line_row = arr[0].length;
    var ui_line_col = arr.length;

    for (let idx = 0; idx < ui_line_row; idx++) {
        arr_result.push([]);
        for (let idx_s = 0; idx_s < ui_line_col; idx_s++) {
            arr_result[idx].push({ jx_num: "" });
        }
    }
    return arr_result;
}

/* * 功能:
* 处理偏移和引脚对象数据生成箱体数据的data */
function mc_handle_col_data(arr_offset, arr_jx, obj_page_data, arr_group_cnt) {
    var arr_result = [];
    // 存储j值的模组数据
    var obj_item = {};

    // 倒序
    if ("1" === obj_page_data.plug) {
        // 整体翻转
        arr_jx = arr_jx.reverse();
    }

    // 方向处理 从右到左/从下到上
    if ("1" === obj_page_data.cascade || "3" === obj_page_data.cascade) {
        for (var item_1 = 0; item_1 < arr_jx.length; item_1++) {
            // 重列顺序
            arr_jx[item_1] = arr_jx[item_1].reverse();
        }
    }

    // 纵向处理
    // eslint-disable-next-line no-empty
    if ("2" === obj_page_data.cascade || "3" === obj_page_data.cascade) {
        var arr_reset_queen = new Array(arr_jx[0].length);

        var ui_len = arr_jx[0].length;

        for (var id_prev = 0; id_prev < ui_len; id_prev++) {
            for (var id_next = 0; id_next < arr_jx.length; id_next++) {
                if (!arr_reset_queen[id_prev]) {
                    arr_reset_queen[id_prev] = [];
                }
                arr_reset_queen[id_prev].push(arr_jx[id_next][id_prev]);
            }
        }
        arr_jx = arr_reset_queen;

        var arr_group_result = mc_get_order_group_col(arr_group_cnt, obj_page_data.cascade);

        // 设置相同j的模组 使用arr_group_cnt 从上到下
        // if ("2" === obj_page_data.cascade) {
        for (var idx_col = 0; idx_col < arr_jx.length; idx_col++) {
            for (var idx_col_item = 0; idx_col_item < arr_jx[idx_col].length; idx_col_item++) {
                if (!obj_item[arr_jx[idx_col][idx_col_item].jx_num]) {
                    obj_item[arr_jx[idx_col][idx_col_item].jx_num] = [];
                    obj_item[arr_jx[idx_col][idx_col_item].jx_num].push(arr_offset[arr_group_result[idx_col]][idx_col_item]);
                } else {
                    obj_item[arr_jx[idx_col][idx_col_item].jx_num].push(arr_offset[arr_group_result[idx_col]][idx_col_item]);
                }
            }
        }
        // }
    } else {
        // 横向处理
        // 设置相同j的模组 使用arr_group_cnt 从左到右
        // if ("0" === obj_page_data.cascade) {
        var arr_row_order = mc_get_order_group_row(arr_group_cnt, obj_page_data.cascade);

        for (var idx_row = 0; idx_row < arr_jx.length; idx_row++) {
            for (var idx_row_item = 0; idx_row_item < arr_jx[idx_row].length; idx_row_item++) {
                if (!obj_item[arr_jx[idx_row][idx_row_item].jx_num]) {
                    obj_item[arr_jx[idx_row][idx_row_item].jx_num] = [];
                    obj_item[arr_jx[idx_row][idx_row_item].jx_num].push(arr_offset[idx_row][arr_row_order[idx_row_item]]);
                } else {
                    obj_item[arr_jx[idx_row][idx_row_item].jx_num].push(arr_offset[idx_row][arr_row_order[idx_row_item]]);
                }
            }
        }
        // }
    }


    // 设置成箱体参数数据形式
    // eslint-disable-next-line guard-for-in
    for (const key in obj_item) {
        var obj_each = new mc_construct_pin_mods_cnt();
        var arr_each = obj_item[key];

        // if ("1" === obj_page_data.cascade) {
        //     arr_each = arr_each.reverse();
        // }

        // 设置参数
        var str_key = key.slice(1);

        obj_each.jx_num = str_key;
        for (var id = 0; id < arr_each.length; id++) {
            // 修改偏移类型
            // eslint-disable-next-line operator-assignment
            arr_each[id].offset_x = arr_each[id].offset_x + "";
            // eslint-disable-next-line operator-assignment
            arr_each[id].offset_y = arr_each[id].offset_y + "";

            obj_each.children.push(arr_each[id]);
        }

        var ui_num = Number(str_key);

        arr_result[ui_num - 1] = obj_each;
    }


    return arr_result;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取对开添加模块顺序数组
 * 参数:
 *     @param {Promise<Array>} arr_output_sort 每项为对开每组个数
 * 返回：
 *     @returns {Promise<Array>}
 *      false 参数错误
 *      arr_result 顺序下标数组
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.01
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_split_pot(arr_output_sort) {
    if (!(Array.isArray(arr_output_sort)) || 0 === arr_output_sort.length) {
        return false;
    }
    var arr_result = [];
    var ui_sort = 0;
    var arr_index = [];

    for (var add = 0; add < arr_output_sort.length; add++) {
        var ui_add = arr_output_sort[add];

        for (var j = 0; j < ui_add; j++) {
            arr_index.push(ui_sort);
            ui_sort++;
        }

        if (1 === add % 2) {
            arr_index = arr_index.reverse();
        }
        arr_result = arr_result.concat(arr_index);
        arr_index = [];
    }
    return arr_result;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    特殊处理 从下到上的级联
 * 参数:
 *     @param {Promise<Array>} arr_output_sort 每项为对开每组个数
 *     @param {Promise<string>} str_scacase 级联类型
 * 返回：
 *     @returns {Promise<Array>}
 *      false 参数错误
 *      arr_result 顺序下标数组
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.02
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_order_group_col(arr_output_sort, str_scacase) {
    if (!(Array.isArray(arr_output_sort)) || 0 === arr_output_sort.length) {
        return false;
    }
    var arr_result = [];
    var ui_sort = 0;
    var arr_index = [];

    if ("3" === str_scacase) {
        var arr_temp = [];

        for (var id_add_sort = 0; id_add_sort < arr_output_sort.length; id_add_sort++) {
            ui_sort += Number(arr_output_sort[id_add_sort]);
        }
        ui_sort -= 1;

        for (var id_bottom = 0; id_bottom < arr_output_sort.length; id_bottom++) {
            var ui_add_bottom = arr_output_sort[id_bottom];

            for (var id_b_o = 0; id_b_o < ui_add_bottom; id_b_o++) {
                arr_index.push(ui_sort);
                ui_sort--;
            }

            if (1 === id_bottom % 2) {
                arr_index = arr_index.reverse();
            }
            arr_temp.unshift(arr_index);

            arr_index = [];
        }
        for (var id_temp = 0; id_temp < arr_temp.length; id_temp++) {
            for (var id_son = 0; id_son < arr_temp[id_temp].length; id_son++) {
                arr_result.push(arr_temp[id_temp][id_son]);
            }
        }

        // arr_result = arr_result.concat(arr_index);
    } else {
        for (var id_top = 0; id_top < arr_output_sort.length; id_top++) {
            var ui_add_top = arr_output_sort[id_top];

            for (var id_t_o = 0; id_t_o < ui_add_top; id_t_o++) {
                arr_index.push(ui_sort);
                ui_sort++;
            }

            if (1 === id_top % 2) {
                arr_index = arr_index.reverse();
            }
            arr_result = arr_result.concat(arr_index);
            arr_index = [];
        }
    }

    return arr_result;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    特殊处理 从右到左
 * 参数:
 *     @param {Promise<Array>} arr_output_sort 每项为对开每组个数
 *     @param {Promise<string>} str_scacase 级联类型
 * 返回：
 *     @returns {Promise<Array>}
 *      false 参数错误
 *      arr_result 顺序下标数组
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.02
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_order_group_row(arr_output_sort, str_scacase) {
    if (!(Array.isArray(arr_output_sort)) || 0 === arr_output_sort.length) {
        return false;
    }
    var arr_result = [];
    var ui_sort = 0;
    var arr_index = [];

    // 从右到左
    if ("1" === str_scacase) {
        for (var id_add_sort = 0; id_add_sort < arr_output_sort.length; id_add_sort++) {
            ui_sort += Number(arr_output_sort[id_add_sort]);
        }
        ui_sort -= 1;
        var arr_temp = [];
        // arr_output_sort = arr_output_sort.reverse();

        for (var id_right = 0; id_right < arr_output_sort.length; id_right++) {
            var ui_right = arr_output_sort[id_right];

            for (var id_right_o = 0; id_right_o < ui_right; id_right_o++) {
                arr_index.push(ui_sort);
                ui_sort--;
            }

            if (1 === id_right % 2) {
                arr_index = arr_index.reverse();
            }
            arr_temp.unshift(arr_index);
            arr_index = [];
        }

        for (var id_temp = 0; id_temp < arr_temp.length; id_temp++) {
            for (var id_son = 0; id_son < arr_temp[id_temp].length; id_son++) {
                arr_result.push(arr_temp[id_temp][id_son]);
            }
        }
        // arr_result = arr_result.concat(arr_index);
    } else {
        for (var id_left = 0; id_left < arr_output_sort.length; id_left++) {
            var ui_left = arr_output_sort[id_left];

            for (var id_right_t = 0; id_right_t < ui_left; id_right_t++) {
                arr_index.push(ui_sort);
                ui_sort++;
            }

            if (1 === id_left % 2) {
                arr_index = arr_index.reverse();
            }
            arr_result = arr_result.concat(arr_index);
            arr_index = [];
        }
    }


    return arr_result;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取对应名称下标
 * 参数:
 *    @param {Promise<Array>} ary_data 数据数组
 *    @param {Promise<string>} str_name 名称
 * 返回：
 *    @returns {Promise<number>} 对应名称在数组中下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.01
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_layout_get_data_idx_in_name(ary_data, str_name) {
    if (!Array.isArray(ary_data) || 0 >= ary_data.length) {
        return false;
    }
    for (var idx = 0; idx < ary_data.length; idx++) {
        if (str_name === ary_data[idx].name) {
            return idx;
        }
    }
    return false;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取箱体信息
 * 参数:
 *    @param {Promise<string>} box_name 箱体名称
 *    @param {Promise<Array>} ary_box_data 箱体数据
 *    @param {Promise<Array>} obj_data 模组数据
 * 返回：
 *    @returns {Promise<Object>} 箱体基本信息(宽高,主控/hub芯片名)
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.01
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_layout_get_box_basic(box_name, ary_box_data, obj_data) {
    if ("string" !== typeof box_name || 0 >= box_name.length) {
        return false;
    }
    if (!Array.isArray(ary_box_data) || 0 >= ary_box_data.length) {
        return false;
    }
    var ui_box_idx = mc_layout_get_data_idx_in_name(ary_box_data, box_name);

    if ("number" !== typeof ui_box_idx) {
        return false;
    }
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();

    var obj_box_data = ary_box_data[ui_box_idx].data;
    var obj_recvcard_data = obj_box_data.mc_util_get_ui_box_msg();
    var str_ctrlchip_name = obj_recvcard_data.ctrlchip_name;
    var str_hub_name = obj_recvcard_data.hub_name;

    obj_sdk_param.set_param_value("MC_LANG_CTRLCHIP_LIST", str_ctrlchip_name);
    obj_sdk_param.set_attr_val("MC_LANG_CTRLCHIP_LIST", "UI_TYPE", "LABEL");
    obj_sdk_param.set_param_value("MC_LANG_LABLE_HUB", str_hub_name);
    obj_sdk_param.set_attr_val("MC_LANG_LABLE_HUB", "UI_TYPE", "LABEL");

    obj_sdk_param.set_param_value("MC_LANG_LABLE_WEITH", obj_data.width);
    obj_sdk_param.set_attr_val("MC_LANG_LABLE_WEITH", "UI_TYPE", "LABEL");

    obj_sdk_param.set_param_value("MC_LANG_LABLE_HEIGHT", obj_data.height);
    obj_sdk_param.set_attr_val("MC_LANG_LABLE_HEIGHT", "UI_TYPE", "LABEL");
    return JSON.parse(obj_sdk_param.get_json());
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    存入箱体链接中引脚字段
 * 参数:
 *    @param {Promise<Object>} obj_box_msg 箱体页面生成数据
 *    @param {Promise<String>} str_box_first_mod_name 箱体下最小jx下第一个模组名称
 *    @param {Promise<Array>} ary_mod_data 模组数据
 * 返回：
 *    @return {Promise<Number>} 存入结果
 * 备注:
 *    与箱体连接界面存入箱体信息不同的是 不需要判断图像 都是用同一个模组生成箱体
 * 注意:
 *      1.一个箱内的所有芯片，行扫数，数据串类型必需一致（串行不管几灯串还是乱串，都认为是串行）
 *      2.至于第一个口是一组数据，第二个口是两组数据，这个不强制，但是你那边可以简单点处理，要求必需一样
 *      3.三线并行的，三个线颜色顺序可以不一样，但是一个组串的所有模组，必需一样，这个也一样，你那边可以简单一点处理，要求必需一样
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.06.18
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_box_xml(obj_box_msg, str_box_first_mod_name, ary_mod_data) {
    // 控制芯片名称
    var str_ctrlchip_name = obj_box_msg.ctrlchip_name;
    // hub芯片名称
    var str_hub_name = obj_box_msg.hub_name;
    // 所有模组列表数据
    var ary_module_list = obj_box_msg.data;
    // dsp描述信息
    var obj_hub_msg = obj_box_msg.edit_val;

    var obj_sdk_recvcard = new mc_sdk_recvcard();

    // 存入主控芯片名称
    obj_sdk_recvcard.mc_util_recvcard_set_ctrlchip_name(str_ctrlchip_name);
    // 存入hub名称
    obj_sdk_recvcard.mc_util_recvcard_set_hub_name(str_hub_name);
    obj_sdk_recvcard.mc_util_recvcard_set_hub_msg(obj_hub_msg);


    var ui_first_mod_idx = mc_main_get_data_idx_in_name(ary_mod_data, str_box_first_mod_name);

    var obj_first_mod_data = ary_mod_data[ui_first_mod_idx].data;
    // 线数量
    var ui_str_cnt = Number(obj_first_mod_data.mc_util_mod_get_str_cnt());


    for (var idx_jx = 0; idx_jx < ary_module_list.length; idx_jx++) {
        var jx_num = ary_module_list[idx_jx].jx_num;
        var ary_jx_modlist = ary_module_list[idx_jx].children;

        for (var idx_mod = 0; idx_mod < ary_jx_modlist.length; idx_mod++) {
            var str_module_name = ary_jx_modlist[idx_mod].module_name;
            var str_offset_x = ary_jx_modlist[idx_mod].offset_x;
            var str_offset_y = ary_jx_modlist[idx_mod].offset_y;
            var str_mirror = ary_jx_modlist[idx_mod].mirror;
            var str_rotation = ary_jx_modlist[idx_mod].rotation;
            var str_scale = ary_jx_modlist[idx_mod].scale;
            var str_cut = ary_jx_modlist[idx_mod].cut || "0,0,0,0";

            obj_sdk_recvcard.mc_util_recvcard_set_modlist_mod_info(idx_jx, idx_mod, str_module_name, str_offset_x, str_offset_y, str_mirror, str_rotation, str_scale,str_cut);
        }


        jx_num = Number(jx_num) - 1;
        var str_dsp_val = "";
        var ui_dsp_val = Number(jx_num) * ui_str_cnt;
        var ui_fist_mod_idx = mc_main_get_data_idx_in_name(ary_mod_data, ary_jx_modlist[0].module_name);

        for (var idx_dsp = 0; idx_dsp < ui_str_cnt; idx_dsp++) {
            var str_idx_dsp = ary_mod_data[ui_fist_mod_idx].data.mc_util_mod_get_str_pin(idx_dsp);

            str_dsp_val += "(DSP" + ui_dsp_val + ":" + str_idx_dsp + "),";
            ui_dsp_val++;
        }
        obj_sdk_recvcard.mc_util_recvcard_set_modlist_pin_pair_exp(idx_jx, str_dsp_val);
    }
    return obj_sdk_recvcard;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    查询数组中对象name属性为指定名称的下标
 * 参数:
 *    @param {Promise<Array>} ary_data 查询数组
 *    @param {Promise<Array>} str_name_value 查询名称
 * 返回：
 *    @returns {Promise<Boolean>} 是否不同
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.6.18
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_main_get_data_idx_in_name(ary_data, str_name_value) {
    if (
        !Array.isArray(ary_data) ||
        !str_name_value
    ) {
        return -1;
    }
    var ui_return = -1;

    for (var idx = 0; idx < ary_data.length; idx++) {
        var obj_data = ary_data[idx];

        if (obj_data.name === str_name_value) {
            ui_return = idx;
            break;
        }
    }
    return ui_return;
}
